//
//  MCPGQueryResult.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 25/08/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>

#include "libpq-fe.h"


// NOTE: The columnNameHints lookup dictionary is used to translate column names coming from PG to key names to use in the record dictionaries.
//        The lookup is 2 levels deep, the first level is the OID of the table in the database, then the PG column name, which gives the key name

@interface MCPGQueryResult : NSObject {
	PGresult*       result;

	unsigned int    rowIndex;
	
	BOOL            eliminateNSNulls;
	NSDictionary*   columnNameHints; // See note above class declaration for info
	NSDictionary*   columnTypeHints;
}

- (id)initWithResult: (PGresult*)aResult;
- (void)finalizeResult;  // clears the result - after calling this method the instance will be invalid

- (BOOL)wasSuccessful;
- (ExecStatusType)status;
- (unsigned int)count;
- (unsigned int)affectedRows;

- (id)nextObject;
- (NSArray*)allObjects;

- (NSArray *)columnNames;
- (NSArray *)stringColumnNames;


- (BOOL)eliminateNSNulls;
- (void)setEliminateNSNulls:(BOOL)flag;
- (NSDictionary *)columnNameHints;
- (void)setColumnNameHints:(NSDictionary *)aColumnNameHints;
- (NSDictionary *)columnTypeHints;
- (void)setColumnTypeHints:(NSDictionary *)aColumnTypeHints;

@end
